plugins {
    alias(libs.plugins.android.application)
}

android {
    namespace = "com.company.tp07_03_remotetodoapp"
    compileSdk = 34

    defaultConfig {
        applicationId = "com.company.tp07_03_remotetodoapp"
        minSdk = 24
        targetSdk = 34
        versionCode = 1
        versionName = "1.0"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_1_8
        targetCompatibility = JavaVersion.VERSION_1_8
    }
}

dependencies {
    val retro = "2.11.0"
    implementation("com.squareup.retrofit2:retrofit:$retro")
    implementation("com.squareup.retrofit2:converter-gson:$retro")
    implementation("com.squareup.retrofit2:adapter-rxjava3:$retro")

    implementation(libs.appcompat)
    implementation(libs.material)
    implementation(libs.activity)
    implementation(libs.constraintlayout)
    testImplementation(libs.junit)
    androidTestImplementation(libs.ext.junit)
    androidTestImplementation(libs.espresso.core)
}